/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.entity.blockentities.BigFlowerPotBlockEntity;
import net.satisfyu.meadow.entity.blockentities.CheeseFormBlockEntity;
import net.satisfyu.meadow.entity.blockentities.CheeseRackBlockEntity;
import net.satisfyu.meadow.entity.blockentities.CookingCauldronBlockEntity;
import net.satisfyu.meadow.entity.blockentities.FlowerBoxBlockEntity;
import net.satisfyu.meadow.entity.blockentities.FondueBlockEntity;
import net.satisfyu.meadow.entity.blockentities.ShelfBlockEntity;
import net.satisfyu.meadow.entity.blockentities.StoveBlockWoodBlockEntity;
import net.satisfyu.meadow.entity.blockentities.WheelBarrowBlockEntity;
import net.satisfyu.meadow.registry.ObjectRegistry;

public class BlockEntityRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registry.f_122907_);
    public static final RegistrySupplier<BlockEntityType<CookingCauldronBlockEntity>> COOKING_CAULDRON = BlockEntityRegistry.createBlockEntity("cooking_pot", () -> BlockEntityType.Builder.m_155273_(CookingCauldronBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_CAULDRON.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CheeseFormBlockEntity>> CHEESE_FORM_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("cheese_form", () -> BlockEntityType.Builder.m_155273_(CheeseFormBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_FORM.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CheeseRackBlockEntity>> CHEESE_RACK_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("cheese_rack", () -> BlockEntityType.Builder.m_155273_(CheeseRackBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHEESE_RACK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<WheelBarrowBlockEntity>> WHEEL_BARROW_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("wheel_barrow", () -> BlockEntityType.Builder.m_155273_(WheelBarrowBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WHEELBARROW.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FlowerBoxBlockEntity>> FLOWER_BOX_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("flower_box", () -> BlockEntityType.Builder.m_155273_(FlowerBoxBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WOODEN_FLOWER_BOX.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<BigFlowerPotBlockEntity>> BIG_FLOWER_POT_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("big_flower_pot", () -> BlockEntityType.Builder.m_155273_(BigFlowerPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FLOWER_POT_BIG.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FondueBlockEntity>> FONDUE = BlockEntityRegistry.createBlockEntity("fondue", () -> BlockEntityType.Builder.m_155273_(FondueBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FONDUE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ShelfBlockEntity>> SHELF_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("shelf", () -> BlockEntityType.Builder.m_155273_(ShelfBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SHELF.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockWoodBlockEntity>> STOVE_BLOCK_WOOD_BLOCK_ENTITY = BlockEntityRegistry.createBlockEntity("stove_block_wood", () -> BlockEntityType.Builder.m_155273_(StoveBlockWoodBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STOVE_WOOD.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> createBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        Meadow.LOGGER.debug("Registering Mod BlockEntities for meadow");
        BLOCK_ENTITY_TYPES.register();
    }
}

